/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.collections.ints;

/**
 * List of int numbers.
 *
 * @author Dawid Kurzyniec
 * @version 1.0
 */
public interface IntList extends IntCollection {
    int size();
    boolean isEmpty();
    boolean contains(int e);
    IntIterator iterator();
    int[] toArray();
    int[] toArray(int a[]);
    boolean add(int e);
    boolean remove(int e);
    boolean containsAll(IntCollection c);
    boolean addAll(IntCollection c);
    boolean addAll(int index, IntCollection c);
    boolean removeAll(IntCollection c);
    boolean retainAll(IntCollection c);
    void clear();
    boolean equals(Object o);
    int hashCode();

    /**
     * Returns the value at the specified index.
     *
     * @param index the index to retrieve the value from.
     * @return the value at the specified index.
     * @throws IndexOutOfBoundsException if index < 0 or index >= size.
     */
    int getAt(int index);

    /**
     * Sets the value at the specified index.
     *
     * @param index the index to set the value at.
     * @param e the new value.
     * @return the value previously present the specified index.
     * @throws IndexOutOfBoundsException if index < 0 or index >= size.
     */
    int setAt(int index, int e);

    /**
     * Adds the value at the specified index, and moves elements starting
     * at index to the right.
     *
     * @param index the index to add the value at.
     * @param e the new value.
     * @throws IndexOutOfBoundsException if index < 0 or index > size.
     */
    void addAt(int index, int e);

    /**
     * Removes the value at the specified index, and shifts elements starting
     * at index+1 to the left.
     *
     * @param index the index to remove the value from.
     * @return the value previously present at the specified index.
     * @throws IndexOutOfBoundsException if index < 0 or index >= size.
     */
    int removeAt(int index);

    /**
     * Returns the smallest index at which the list contains the specified
     * number.
     * @param e the number to look for
     * @return the smallest index of e
     */
    int indexOf(int e);

    /**
     * Returns the largest index at which the list contains the specified
     * number.
     * @param e the number to look for
     * @return the largest index of e
     */
    int lastIndexOf(int e);

    IntListIterator listIterator();

    IntListIterator listIterator(int index);

    IntList subList(int fromIndex, int toIndex);
}
